// generate FreeFont from UTFT font
const uint8_t FreeSmallFontBitmaps[] PROGMEM = {
// 0x0 [0x20 '.']

// 1x8 [0x21 '!']
0xFD,
// 4x3 [0x22 '"']
0x5A,0xA0,
// 6x8 [0x23 '#']
0x28,0xAF,0xCA,0x53,0xF5,0x14,
// 5x10 [0x24 '$']
0x23,0xEB,0x46,0x18,0xB5,0xF1,0x00,
// 6x8 [0x25 '%']
0x4A,0xAB,0x14,0x28,0xD5,0x52,
// 6x8 [0x26 '&']
0x21,0x45,0x1E,0xAA,0xA9,0x1B,
// 2x3 [0x27 ''']
0x58,
// 3x10 [0x28 '(']
0x2A,0x49,0x24,0x44,
// 3x10 [0x29 ')']
0x88,0x92,0x49,0x50,
// 5x6 [0x2A '*']
0x25,0x5C,0xEA,0x90,
// 5x7 [0x2B '+']
0x21,0x09,0xF2,0x10,0x80,
// 2x3 [0x2C ',']
0x58,
// 5x1 [0x2D '-']
0xF8,
// 1x1 [0x2E '.']
0x80,
// 5x10 [0x2F '/']
0x08,0x84,0x22,0x11,0x08,0x44,0x00,
// 5x8 [0x30 '0']
0x74,0x63,0x18,0xC6,0x2E,
// 3x8 [0x31 '1']
0x59,0x24,0x97,
// 5x8 [0x32 '2']
0x74,0x62,0x22,0x22,0x1F,
// 5x8 [0x33 '3']
0x74,0x42,0x60,0x86,0x2E,
// 5x8 [0x34 '4']
0x11,0x94,0xA9,0x3C,0x43,
// 5x8 [0x35 '5']
0xFC,0x21,0xE0,0x86,0x2E,
// 5x8 [0x36 '6']
0x74,0xA1,0xE8,0xC6,0x2E,
// 5x8 [0x37 '7']
0xFC,0x84,0x42,0x10,0x84,
// 5x8 [0x38 '8']
0x74,0x62,0xE8,0xC6,0x2E,
// 5x8 [0x39 '9']
0x74,0x63,0x17,0x85,0x2E,
// 1x6 [0x3A ':']
0x84,
// 1x6 [0x3B ';']
0x8C,
// 5x9 [0x3C '<']
0x08,0x88,0x88,0x20,0x82,0x08,
// 5x4 [0x3D '=']
0xF8,0x01,0xF0,
// 5x9 [0x3E '>']
0x82,0x08,0x20,0x88,0x88,0x80,
// 5x8 [0x3F '?']
0x74,0x62,0x22,0x10,0x04,
// 5x8 [0x40 '@']
0x74,0x67,0x5A,0xDE,0x0F,
// 6x8 [0x41 'A']
0x20,0x83,0x14,0x51,0xE4,0xB3,
// 5x8 [0x42 'B']
0xF2,0x52,0xE4,0xA5,0x3E,
// 5x8 [0x43 'C']
0x7C,0x61,0x08,0x42,0x2E,
// 5x8 [0x44 'D']
0xF2,0x52,0x94,0xA5,0x3E,
// 5x8 [0x45 'E']
0xFA,0x54,0xE5,0x21,0x3F,
// 5x8 [0x46 'F']
0xFA,0x54,0xE5,0x21,0x1C,
// 6x8 [0x47 'G']
0x39,0x28,0x20,0x9E,0x24,0x8C,
// 6x8 [0x48 'H']
0xCD,0x24,0x9E,0x49,0x24,0xB3,
// 5x8 [0x49 'I']
0xF9,0x08,0x42,0x10,0x9F,
// 6x9 [0x4A 'J']
0x7C,0x41,0x04,0x10,0x41,0x24,0xE0,
// 6x8 [0x4B 'K']
0xED,0x25,0x18,0x51,0x44,0xBB,
// 6x8 [0x4C 'L']
0xE1,0x04,0x10,0x41,0x04,0x7F,
// 5x8 [0x4D 'M']
0xDE,0xF7,0xBA,0xD6,0xB5,
// 6x8 [0x4E 'N']
0xDD,0x26,0x9A,0x59,0x64,0xBA,
// 5x8 [0x4F 'O']
0x74,0x63,0x18,0xC6,0x2E,
// 5x8 [0x50 'P']
0xF2,0x52,0xE4,0x21,0x1C,
// 5x9 [0x51 'Q']
0x74,0x63,0x18,0xF6,0x6E,0x18,
// 6x8 [0x52 'R']
0xF1,0x24,0x9C,0x51,0x24,0xBB,
// 5x8 [0x53 'S']
0x7C,0x60,0xC1,0x06,0x3E,
// 5x8 [0x54 'T']
0xFD,0x48,0x42,0x10,0x8E,
// 6x8 [0x55 'U']
0xCD,0x24,0x92,0x49,0x24,0x8C,
// 6x8 [0x56 'V']
0xCD,0x24,0x94,0x50,0xC2,0x08,
// 5x8 [0x57 'W']
0xAD,0x6A,0xE5,0x29,0x4A,
// 5x8 [0x58 'X']
0xDA,0x94,0x42,0x29,0x5B,
// 5x8 [0x59 'Y']
0xDA,0x94,0x42,0x10,0x8E,
// 5x8 [0x5A 'Z']
0xFC,0x84,0x42,0x21,0x3F,
// 3x10 [0x5B '[']
0xF2,0x49,0x24,0x9C,
// 4x9 [0x5C '\']
0x88,0x84,0x42,0x22,0x10,
// 3x10 [0x5D ']']
0xE4,0x92,0x49,0x3C,
// 3x2 [0x5E '^']
0x54,
// 6x1 [0x5F '_']
0xFC,
// 1x1 [0x60 '`']
0x80,
// 5x5 [0x61 'a']
0x64,0x9D,0x27,0x80,
// 5x8 [0x62 'b']
0xC2,0x10,0xE4,0xA5,0x2E,
// 4x5 [0x63 'c']
0x79,0x88,0x70,
// 5x8 [0x64 'd']
0x30,0x84,0xE9,0x4A,0x4F,
// 4x5 [0x65 'e']
0x69,0xF8,0x70,
// 5x8 [0x66 'f']
0x3A,0x11,0xE4,0x21,0x1E,
// 5x7 [0x67 'g']
0x7C,0x99,0x0F,0x45,0xC0,
// 6x8 [0x68 'h']
0xC1,0x04,0x1C,0x49,0x24,0xBB,
// 3x8 [0x69 'i']
0x40,0x64,0x97,
// 4x10 [0x6A 'j']
0x10,0x03,0x11,0x11,0x1E,
// 6x8 [0x6B 'k']
0xC1,0x04,0x17,0x51,0xC4,0xBB,
// 5x8 [0x6C 'l']
0xE1,0x08,0x42,0x10,0x9F,
// 5x5 [0x6D 'm']
0xF5,0x6B,0x5A,0x80,
// 6x5 [0x6E 'n']
0xF1,0x24,0x92,0xEC,
// 4x5 [0x6F 'o']
0x69,0x99,0x60,
// 5x7 [0x70 'p']
0xF2,0x52,0x97,0x23,0x80,
// 5x7 [0x71 'q']
0x74,0xA5,0x27,0x08,0xE0,
// 5x5 [0x72 'r']
0xDB,0x10,0x8E,0x00,
// 4x5 [0x73 's']
0xF8,0x61,0xF0,
// 4x7 [0x74 't']
0x44,0xE4,0x44,0x30,
// 6x5 [0x75 'u']
0xD9,0x24,0x92,0x3C,
// 6x5 [0x76 'v']
0xED,0x25,0x0C,0x20,
// 5x5 [0x77 'w']
0xAD,0x5C,0xA5,0x00,
// 5x5 [0x78 'x']
0xDA,0x88,0xAD,0x80,
// 6x7 [0x79 'y']
0xED,0x25,0x0C,0x20,0x8C,0x00,
// 4x5 [0x7A 'z']
0xF2,0x44,0xF0,
// 3x10 [0x7B '{']
0x69,0x28,0x92,0x4C,
// 1x12 [0x7C '|']
0xFF,0xF0,
// 3x10 [0x7D '}']
0xC9,0x22,0x92,0x58,
// 6x3 [0x7E '~']
0x42,0x91,0x80,
};
const GFXglyph FreeSmallFontGlyphs[] PROGMEM = {
    {   0,  0,  0,  8,  8, -12 }, // 0x20 ' '
    {   0,  1,  8,  8,  2, -10 }, // 0x21 '!'
    {   1,  4,  3,  8,  1, -11 }, // 0x22 '"'
    {   3,  6,  8,  8,  0, -10 }, // 0x23 '#'
    {   9,  5, 10,  8,  0, -11 }, // 0x24 '$'
    {  16,  6,  8,  8,  0, -10 }, // 0x25 '%'
    {  22,  6,  8,  8,  0, -10 }, // 0x26 '&'
    {  28,  2,  3,  8,  0, -11 }, // 0x27 '''
    {  29,  3, 10,  8,  3, -11 }, // 0x28 '('
    {  33,  3, 10,  8,  1, -11 }, // 0x29 ')'
    {  37,  5,  6,  8,  0,  -9 }, // 0x2A '*'
    {  41,  5,  7,  8,  0, -10 }, // 0x2B '+'
    {  46,  2,  3,  8,  0,  -3 }, // 0x2C ','
    {  47,  5,  1,  8,  0,  -7 }, // 0x2D '-'
    {  48,  1,  1,  8,  1,  -3 }, // 0x2E '.'
    {  49,  5, 10,  8,  0, -11 }, // 0x2F '/'
    {  56,  5,  8,  8,  0, -10 }, // 0x30 '0'
    {  61,  3,  8,  8,  1, -10 }, // 0x31 '1'
    {  64,  5,  8,  8,  0, -10 }, // 0x32 '2'
    {  69,  5,  8,  8,  0, -10 }, // 0x33 '3'
    {  74,  5,  8,  8,  0, -10 }, // 0x34 '4'
    {  79,  5,  8,  8,  0, -10 }, // 0x35 '5'
    {  84,  5,  8,  8,  0, -10 }, // 0x36 '6'
    {  89,  5,  8,  8,  0, -10 }, // 0x37 '7'
    {  94,  5,  8,  8,  0, -10 }, // 0x38 '8'
    {  99,  5,  8,  8,  0, -10 }, // 0x39 '9'
    { 104,  1,  6,  8,  2,  -8 }, // 0x3A ':'
    { 105,  1,  6,  8,  2,  -7 }, // 0x3B ';'
    { 106,  5,  9,  8,  1, -11 }, // 0x3C '<'
    { 112,  5,  4,  8,  0,  -8 }, // 0x3D '='
    { 115,  5,  9,  8,  1, -11 }, // 0x3E '>'
    { 121,  5,  8,  8,  0, -10 }, // 0x3F '?'
    { 126,  5,  8,  8,  0, -10 }, // 0x40 '@'
    { 131,  6,  8,  8,  0, -10 }, // 0x41 'A'
    { 137,  5,  8,  8,  0, -10 }, // 0x42 'B'
    { 142,  5,  8,  8,  0, -10 }, // 0x43 'C'
    { 147,  5,  8,  8,  0, -10 }, // 0x44 'D'
    { 152,  5,  8,  8,  0, -10 }, // 0x45 'E'
    { 157,  5,  8,  8,  0, -10 }, // 0x46 'F'
    { 162,  6,  8,  8,  0, -10 }, // 0x47 'G'
    { 168,  6,  8,  8,  0, -10 }, // 0x48 'H'
    { 174,  5,  8,  8,  0, -10 }, // 0x49 'I'
    { 179,  6,  9,  8,  0, -10 }, // 0x4A 'J'
    { 186,  6,  8,  8,  0, -10 }, // 0x4B 'K'
    { 192,  6,  8,  8,  0, -10 }, // 0x4C 'L'
    { 198,  5,  8,  8,  0, -10 }, // 0x4D 'M'
    { 203,  6,  8,  8,  0, -10 }, // 0x4E 'N'
    { 209,  5,  8,  8,  0, -10 }, // 0x4F 'O'
    { 214,  5,  8,  8,  0, -10 }, // 0x50 'P'
    { 219,  5,  9,  8,  0, -10 }, // 0x51 'Q'
    { 225,  6,  8,  8,  0, -10 }, // 0x52 'R'
    { 231,  5,  8,  8,  0, -10 }, // 0x53 'S'
    { 236,  5,  8,  8,  0, -10 }, // 0x54 'T'
    { 241,  6,  8,  8,  0, -10 }, // 0x55 'U'
    { 247,  6,  8,  8,  0, -10 }, // 0x56 'V'
    { 253,  5,  8,  8,  0, -10 }, // 0x57 'W'
    { 258,  5,  8,  8,  0, -10 }, // 0x58 'X'
    { 263,  5,  8,  8,  0, -10 }, // 0x59 'Y'
    { 268,  5,  8,  8,  0, -10 }, // 0x5A 'Z'
    { 273,  3, 10,  8,  2, -11 }, // 0x5B '['
    { 277,  4,  9,  8,  1, -11 }, // 0x5C '\'
    { 282,  3, 10,  8,  1, -11 }, // 0x5D ']'
    { 286,  3,  2,  8,  1, -11 }, // 0x5E '^'
    { 287,  6,  1,  8,  0,  -1 }, // 0x5F '_'
    { 288,  1,  1,  8,  2, -11 }, // 0x60 '`'
    { 289,  5,  5,  8,  1,  -7 }, // 0x61 'a'
    { 293,  5,  8,  8,  0, -10 }, // 0x62 'b'
    { 298,  4,  5,  8,  1,  -7 }, // 0x63 'c'
    { 301,  5,  8,  8,  1, -10 }, // 0x64 'd'
    { 306,  4,  5,  8,  1,  -7 }, // 0x65 'e'
    { 309,  5,  8,  8,  1, -10 }, // 0x66 'f'
    { 314,  5,  7,  8,  1,  -7 }, // 0x67 'g'
    { 319,  6,  8,  8,  0, -10 }, // 0x68 'h'
    { 325,  3,  8,  8,  1, -10 }, // 0x69 'i'
    { 328,  4, 10,  8,  0, -10 }, // 0x6A 'j'
    { 333,  6,  8,  8,  0, -10 }, // 0x6B 'k'
    { 339,  5,  8,  8,  0, -10 }, // 0x6C 'l'
    { 344,  5,  5,  8,  0,  -7 }, // 0x6D 'm'
    { 348,  6,  5,  8,  0,  -7 }, // 0x6E 'n'
    { 352,  4,  5,  8,  1,  -7 }, // 0x6F 'o'
    { 355,  5,  7,  8,  0,  -7 }, // 0x70 'p'
    { 360,  5,  7,  8,  1,  -7 }, // 0x71 'q'
    { 365,  5,  5,  8,  0,  -7 }, // 0x72 'r'
    { 369,  4,  5,  8,  1,  -7 }, // 0x73 's'
    { 372,  4,  7,  8,  1,  -9 }, // 0x74 't'
    { 376,  6,  5,  8,  0,  -7 }, // 0x75 'u'
    { 380,  6,  5,  8,  0,  -7 }, // 0x76 'v'
    { 384,  5,  5,  8,  0,  -7 }, // 0x77 'w'
    { 388,  5,  5,  8,  0,  -7 }, // 0x78 'x'
    { 392,  6,  7,  8,  0,  -7 }, // 0x79 'y'
    { 398,  4,  5,  8,  1,  -7 }, // 0x7A 'z'
    { 401,  3, 10,  8,  2, -11 }, // 0x7B '{'
    { 405,  1, 12,  8,  3, -12 }, // 0x7C '|'
    { 407,  3, 10,  8,  1, -11 }, // 0x7D '}'
    { 411,  6,  3,  8,  0, -12 }, // 0x7E '~'
};
const GFXfont FreeSmallFont PROGMEM = {
    (uint8_t  *)FreeSmallFontBitmaps,
    (GFXglyph *)FreeSmallFontGlyphs,
    32, 127, 12
};
// FreeSmallFont bitmap size = 414 [1079] [1239]
const uint8_t FreeBigFontBitmaps[] PROGMEM = {
// 0x0 [0x20 '.']

// 5x13 [0x21 '!']
0x77,0xFF,0xFF,0xFD,0xCE,0x00,0x1C,0xE7,0x00,
// 9x5 [0x22 '"']
0xE3,0xF1,0xF8,0xFC,0x76,0x30,
// 14x14 [0x23 '#']
0x18,0x60,0x61,0x81,0x86,0x3F,0xFF,0xFF,0xFC,0x61,0x81,0x86,0x06,0x18,0x18,0x63,
0xFF,0xFF,0xFF,0xC6,0x18,0x18,0x60,0x61,0x80,
// 10x14 [0x24 '$']
0x12,0x04,0x87,0xFF,0xFF,0xD2,0x34,0x8F,0xF9,0xFF,0x12,0xC4,0xBF,0xFF,0xFE,0x12,
0x04,0x80,
// 8x10 [0x25 '%']
0xE1,0xE3,0xE7,0x0E,0x1C,0x38,0x70,0xE7,0xC7,0x87,
// 10x12 [0x26 '&']
0x78,0x33,0x0C,0xC3,0x30,0x78,0x1E,0x17,0xCF,0x3F,0xC7,0xB1,0xCC,0xF9,0xF3,
// 4x4 [0x27 ''']
0x77,0x7E,
// 8x12 [0x28 '(']
0x0F,0x1C,0x38,0x70,0xE0,0xE0,0xE0,0xE0,0x70,0x38,0x1C,0x0F,
// 8x12 [0x29 ')']
0xF0,0x38,0x1C,0x0E,0x07,0x07,0x07,0x07,0x0E,0x1C,0x38,0xF0,
// 12x12 [0x2A '*']
0x06,0x04,0x62,0x26,0x41,0xF8,0x1F,0x8F,0xFF,0xFF,0xF1,0xF8,0x1F,0x82,0x64,0x46,
0x20,0x60,
// 8x8 [0x2B '+']
0x18,0x18,0x18,0xFF,0xFF,0x18,0x18,0x18,
// 4x4 [0x2C ',']
0x77,0x7E,
// 10x2 [0x2D '-']
0xFF,0xFF,0xF0,
// 3x3 [0x2E '.']
0xFF,0x80,
// 12x12 [0x2F '/']
0x00,0x10,0x03,0x00,0x70,0x0E,0x01,0xC0,0x38,0x07,0x00,0xE0,0x1C,0x03,0x80,0x70,
0x0E,0x00,
// 10x12 [0x30 '0']
0x7F,0xB8,0x7E,0x3F,0x9F,0xE7,0xFB,0x7E,0xDF,0xE7,0xF9,0xFC,0x7E,0x1D,0xFE,
// 9x12 [0x31 '1']
0x0C,0x06,0x07,0x1F,0x8F,0xC0,0xE0,0x70,0x38,0x1C,0x0E,0x07,0x1F,0xF0,
// 10x12 [0x32 '2']
0x7F,0x38,0xEE,0x1C,0x07,0x03,0x81,0xC0,0xE0,0x70,0x38,0x1C,0x7E,0x1F,0xFF,
// 10x12 [0x33 '3']
0x7F,0x38,0xEE,0x1C,0x07,0x03,0x87,0x81,0xE0,0x0E,0x01,0xF8,0x7E,0x39,0xFC,
// 10x12 [0x34 '4']
0x07,0x03,0xC1,0xF0,0xDC,0x67,0x31,0xCF,0xFF,0xFF,0x07,0x01,0xC0,0x70,0x7F,
// 10x12 [0x35 '5']
0xFF,0xF8,0x0E,0x03,0x80,0xE0,0x3F,0xCF,0xF8,0x0F,0x01,0xF8,0x7E,0x39,0xFC,
// 10x12 [0x36 '6']
0x1F,0x0E,0x07,0x03,0x80,0xE0,0x3F,0xEF,0xFF,0x87,0xE1,0xF8,0x7E,0x1D,0xFE,
// 11x12 [0x37 '7']
0xFF,0xFC,0x1F,0x83,0xF0,0x70,0x0E,0x03,0x80,0xE0,0x38,0x0E,0x03,0x80,0x70,0x0E,
0x00,
// 10x12 [0x38 '8']
0x7F,0xB8,0x7E,0x1F,0x87,0xF9,0xCF,0xC3,0xF3,0x9F,0xE1,0xF8,0x7E,0x1D,0xFE,
// 10x12 [0x39 '9']
0x7F,0xB8,0x7E,0x1F,0x87,0xE1,0xFF,0xF7,0xFC,0x07,0x01,0xC0,0xE0,0x70,0xF8,
// 3x8 [0x3A ':']
0xFF,0x81,0xFF,
// 4x9 [0x3B ';']
0x77,0x70,0x07,0x77,0xE0,
// 9x14 [0x3C '<']
0x03,0x83,0x83,0x83,0x83,0x83,0x83,0x81,0xC0,0x70,0x1C,0x07,0x01,0xC0,0x70,0x1C,
// 12x6 [0x3D '=']
0xFF,0xFF,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 9x14 [0x3E '>']
0xE0,0x38,0x0E,0x03,0x80,0xE0,0x38,0x0E,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,
// 10x14 [0x3F '?']
0x1E,0x1F,0xEF,0x3F,0x07,0x01,0xC0,0xE0,0x70,0x38,0x0E,0x00,0x00,0x00,0x38,0x0E,
0x03,0x80,
// 11x14 [0x40 '@']
0x7F,0xDC,0x1F,0x83,0xF0,0x7E,0x0F,0xCF,0xF9,0xFF,0x3F,0xE7,0xFC,0x03,0x80,0x70,
0x0F,0xF8,0x7F,0x80,
// 10x12 [0x41 'A']
0x1E,0x0F,0xC7,0x3B,0x87,0xE1,0xF8,0x7E,0x1F,0xFF,0xE1,0xF8,0x7E,0x1F,0x87,
// 10x12 [0x42 'B']
0xFF,0x9C,0x77,0x1D,0xC7,0x71,0xDF,0xE7,0xF9,0xC7,0x71,0xDC,0x77,0x1F,0xFE,
// 10x12 [0x43 'C']
0x3F,0x9C,0x7E,0x1F,0x80,0xE0,0x38,0x0E,0x03,0x80,0xE0,0x38,0x77,0x1C,0xFE,
// 10x12 [0x44 'D']
0xFF,0x1C,0xE7,0x1D,0xC7,0x71,0xDC,0x77,0x1D,0xC7,0x71,0xDC,0x77,0x3B,0xFC,
// 10x12 [0x45 'E']
0xFF,0xDC,0x37,0x05,0xC0,0x71,0x9F,0xE7,0xF9,0xC6,0x70,0x1C,0x17,0x0F,0xFF,
// 10x12 [0x46 'F']
0xFF,0xDC,0x37,0x05,0xC0,0x71,0x9F,0xE7,0xF9,0xC6,0x70,0x1C,0x07,0x03,0xE0,
// 10x12 [0x47 'G']
0x3F,0x9C,0x7E,0x1F,0x87,0xE0,0x38,0x0E,0x03,0x9F,0xE1,0xF8,0x77,0x1C,0xFF,
// 9x12 [0x48 'H']
0xE3,0xF1,0xF8,0xFC,0x7E,0x3F,0xFF,0xFF,0xC7,0xE3,0xF1,0xF8,0xFC,0x70,
// 7x12 [0x49 'I']
0xFE,0x70,0xE1,0xC3,0x87,0x0E,0x1C,0x38,0x70,0xE7,0xF0,
// 12x12 [0x4A 'J']
0x07,0xF0,0x1C,0x01,0xC0,0x1C,0x01,0xC0,0x1C,0x01,0xCE,0x1C,0xE1,0xCE,0x1C,0xE1,
0xC3,0xF8,
// 10x12 [0x4B 'K']
0xF1,0xDC,0x77,0x39,0xDC,0x7E,0x1F,0x07,0xC1,0xF8,0x77,0x1C,0xE7,0x1F,0xC7,
// 10x12 [0x4C 'L']
0xF8,0x1C,0x07,0x01,0xC0,0x70,0x1C,0x07,0x01,0xC0,0x70,0x5C,0x37,0x1F,0xFF,
// 11x12 [0x4D 'M']
0xE0,0xFE,0x3F,0xEF,0xFF,0xFF,0xFF,0xDD,0xF9,0x3F,0x07,0xE0,0xFC,0x1F,0x83,0xF0,
0x70,
// 11x12 [0x4E 'N']
0xE0,0xFC,0x1F,0xC3,0xFC,0x7F,0xCF,0xDD,0xF9,0xFF,0x1F,0xE1,0xFC,0x1F,0x83,0xF0,
0x70,
// 11x12 [0x4F 'O']
0x1F,0x07,0xF1,0xC7,0x70,0x7E,0x0F,0xC1,0xF8,0x3F,0x07,0xE0,0xEE,0x38,0xFE,0x0F,
0x80,
// 10x12 [0x50 'P']
0xFF,0x9C,0x77,0x1D,0xC7,0x71,0xDF,0xE7,0xF9,0xC0,0x70,0x1C,0x07,0x03,0xE0,
// 11x13 [0x51 'Q']
0x1F,0x0F,0x79,0xC7,0x70,0x7E,0x0F,0xC1,0xF8,0x3F,0x1F,0xE7,0xEF,0xF9,0xFF,0x00,
0xE0,0x7E,
// 10x12 [0x52 'R']
0xFF,0x9C,0x77,0x1D,0xC7,0x71,0xDF,0xE7,0xF9,0xCE,0x71,0xDC,0x77,0x1F,0xC7,
// 10x12 [0x53 'S']
0x7F,0xB8,0x7E,0x1F,0x87,0xE0,0x1F,0xC3,0xF8,0x07,0xE1,0xF8,0x7E,0x1D,0xFE,
// 11x12 [0x54 'T']
0xFF,0xF9,0xCE,0x38,0x87,0x00,0xE0,0x1C,0x03,0x80,0x70,0x0E,0x01,0xC0,0x38,0x1F,
0xC0,
// 9x12 [0x55 'U']
0xE3,0xF1,0xF8,0xFC,0x7E,0x3F,0x1F,0x8F,0xC7,0xE3,0xF1,0xF8,0xEF,0xE0,
// 9x12 [0x56 'V']
0xE3,0xF1,0xF8,0xFC,0x7E,0x3F,0x1F,0x8F,0xC7,0xE3,0xBB,0x8F,0x83,0x80,
// 11x12 [0x57 'W']
0xE0,0xFC,0x1F,0x83,0xF0,0x7E,0x0F,0xC9,0xF9,0x3F,0x27,0x7F,0xCF,0xF8,0xEE,0x1D,
0xC0,
// 9x12 [0x58 'X']
0xE3,0xF1,0xF8,0xEE,0xE3,0xE0,0xE0,0x70,0x7C,0x77,0x71,0xF8,0xFC,0x70,
// 9x12 [0x59 'Y']
0xE3,0xF1,0xF8,0xFC,0x7E,0x3B,0xB8,0xF8,0x38,0x1C,0x0E,0x07,0x0F,0xE0,
// 10x12 [0x5A 'Z']
0xFF,0xF8,0x7C,0x1E,0x0E,0x07,0x03,0x81,0xC0,0xE0,0x70,0x78,0x3E,0x1F,0xFF,
// 7x12 [0x5B '[']
0xFF,0xC3,0x87,0x0E,0x1C,0x38,0x70,0xE1,0xC3,0x87,0xF0,
// 13x12 [0x5C '\']
0x80,0x06,0x00,0x38,0x00,0xE0,0x03,0x80,0x0E,0x00,0x38,0x00,0xE0,0x03,0x80,0x0E,
0x00,0x38,0x00,0x70,
// 7x12 [0x5D ']']
0xFE,0x1C,0x38,0x70,0xE1,0xC3,0x87,0x0E,0x1C,0x3F,0xF0,
// 10x5 [0x5E '^']
0x0C,0x07,0x83,0xF1,0xCE,0xE1,0xC0,
// 15x2 [0x5F '_']
0xFF,0xFF,0xFF,0xFC,
// 5x4 [0x60 '`']
0xE7,0x0E,0x70,
// 10x8 [0x61 'a']
0x7F,0x00,0xE0,0x39,0xFE,0xE3,0xB8,0xEE,0x39,0xFB,
// 10x12 [0x62 'b']
0xF0,0x1C,0x07,0x01,0xC0,0x7F,0x9C,0x77,0x1D,0xC7,0x71,0xDC,0x77,0x1F,0x7E,
// 9x8 [0x63 'c']
0x7F,0x71,0xF8,0xFC,0x0E,0x07,0x1F,0x8E,0xFE,
// 10x12 [0x64 'd']
0x07,0xC0,0xE0,0x38,0x0E,0x7F,0xB8,0xEE,0x3B,0x8E,0xE3,0xB8,0xEE,0x39,0xFB,
// 9x8 [0x65 'e']
0x7F,0x71,0xF8,0xFF,0xFE,0x07,0x1F,0x8E,0xFE,
// 9x12 [0x66 'f']
0x1F,0x1D,0xCE,0xE7,0x03,0x87,0xFB,0xFC,0x70,0x38,0x1C,0x0E,0x1F,0xC0,
// 10x10 [0x67 'g']
0x7E,0xF8,0xEE,0x3B,0x8E,0xE3,0x9F,0xE3,0xF8,0x0E,0xE3,0x9F,0xC0,
// 10x12 [0x68 'h']
0xF0,0x1C,0x07,0x01,0xC0,0x77,0x9E,0x77,0x9D,0xC7,0x71,0xDC,0x77,0x1F,0xC7,
// 9x12 [0x69 'i']
0x1C,0x0E,0x07,0x00,0x0F,0xC0,0xE0,0x70,0x38,0x1C,0x0E,0x07,0x1F,0xF0,
// 9x14 [0x6A 'j']
0x03,0x81,0xC0,0xE0,0x01,0xF8,0x1C,0x0E,0x07,0x03,0x81,0xC0,0xFC,0x76,0x79,0xF8,
// 10x12 [0x6B 'k']
0xF0,0x1C,0x07,0x01,0xC0,0x71,0xDC,0xE7,0x71,0xF8,0x77,0x1C,0xE7,0x1F,0xC7,
// 9x12 [0x6C 'l']
0xFC,0x0E,0x07,0x03,0x81,0xC0,0xE0,0x70,0x38,0x1C,0x0E,0x07,0x1F,0xF0,
// 11x8 [0x6D 'm']
0xFF,0xDC,0x9F,0x93,0xF2,0x7E,0x4F,0xC9,0xF9,0x3F,0x27,
// 9x8 [0x6E 'n']
0xFF,0x71,0xF8,0xFC,0x7E,0x3F,0x1F,0x8F,0xC7,
// 9x8 [0x6F 'o']
0x7F,0x71,0xF8,0xFC,0x7E,0x3F,0x1F,0x8E,0xFE,
// 10x10 [0x70 'p']
0xDF,0x9C,0x77,0x1D,0xC7,0x71,0xDC,0x77,0xF9,0xC0,0x70,0x3E,0x00,
// 10x10 [0x71 'q']
0x7E,0xF8,0xEE,0x3B,0x8E,0xE3,0xB8,0xE7,0xF8,0x0E,0x03,0x81,0xF0,
// 10x8 [0x72 'r']
0xF7,0x9F,0xF7,0x9D,0xC0,0x70,0x1C,0x07,0x03,0xE0,
// 9x8 [0x73 's']
0x7F,0x70,0xF8,0x6F,0x81,0xF6,0x1F,0x0E,0xFE,
// 9x11 [0x74 't']
0x08,0x0C,0x0E,0x1F,0xF3,0x81,0xC0,0xE0,0x70,0x3B,0x9D,0xC7,0xC0,
// 10x8 [0x75 'u']
0xE3,0xB8,0xEE,0x3B,0x8E,0xE3,0xB8,0xEE,0x39,0xFB,
// 9x8 [0x76 'v']
0xE3,0xF1,0xF8,0xFC,0x7E,0x3B,0xB8,0xF8,0x38,
// 11x8 [0x77 'w']
0xE0,0xFC,0x1F,0x83,0xF2,0x7E,0x4E,0xFF,0x8E,0xE1,0xDC,
// 8x8 [0x78 'x']
0xE7,0xE7,0x7E,0x3C,0x3C,0x7E,0xE7,0xE7,
// 10x10 [0x79 'y']
0x71,0xDC,0x77,0x1D,0xC7,0x71,0xCF,0xE1,0xF0,0x1C,0x0E,0x3F,0x00,
// 8x8 [0x7A 'z']
0xFF,0xC7,0x8E,0x1C,0x38,0x71,0xE3,0xFF,
// 10x12 [0x7B '{']
0x0F,0xC7,0x01,0xC0,0x70,0x38,0x38,0x0E,0x00,0xE0,0x1C,0x07,0x01,0xC0,0x3F,
// 3x14 [0x7C '|']
0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,
// 10x12 [0x7D '}']
0xFC,0x03,0x80,0xE0,0x38,0x07,0x00,0x70,0x1C,0x1C,0x0E,0x03,0x80,0xE3,0xF0,
// 12x4 [0x7E '~']
0x7C,0x7E,0xE7,0xE7,0x7E,0x3E,
};
const GFXglyph FreeBigFontGlyphs[] PROGMEM = {
    {   0,  0,  0, 16, 16, -16 }, // 0x20 ' '
    {   0,  5, 13, 16,  4, -14 }, // 0x21 '!'
    {   9,  9,  5, 16,  4, -15 }, // 0x22 '"'
    {  15, 14, 14, 16,  1, -15 }, // 0x23 '#'
    {  40, 10, 14, 16,  3, -15 }, // 0x24 '$'
    {  58,  8, 10, 16,  4, -13 }, // 0x25 '%'
    {  68, 10, 12, 16,  3, -14 }, // 0x26 '&'
    {  83,  4,  4, 16,  4, -14 }, // 0x27 '''
    {  85,  8, 12, 16,  4, -14 }, // 0x28 '('
    {  97,  8, 12, 16,  4, -14 }, // 0x29 ')'
    { 109, 12, 12, 16,  2, -14 }, // 0x2A '*'
    { 127,  8,  8, 16,  4, -12 }, // 0x2B '+'
    { 135,  4,  4, 16,  4,  -5 }, // 0x2C ','
    { 137, 10,  2, 16,  3,  -9 }, // 0x2D '-'
    { 140,  3,  3, 16,  5,  -5 }, // 0x2E '.'
    { 142, 12, 12, 16,  3, -14 }, // 0x2F '/'
    { 160, 10, 12, 16,  3, -14 }, // 0x30 '0'
    { 175,  9, 12, 16,  3, -14 }, // 0x31 '1'
    { 189, 10, 12, 16,  3, -14 }, // 0x32 '2'
    { 204, 10, 12, 16,  3, -14 }, // 0x33 '3'
    { 219, 10, 12, 16,  3, -14 }, // 0x34 '4'
    { 234, 10, 12, 16,  3, -14 }, // 0x35 '5'
    { 249, 10, 12, 16,  3, -14 }, // 0x36 '6'
    { 264, 11, 12, 16,  3, -14 }, // 0x37 '7'
    { 281, 10, 12, 16,  3, -14 }, // 0x38 '8'
    { 296, 10, 12, 16,  3, -14 }, // 0x39 '9'
    { 311,  3,  8, 16,  6, -12 }, // 0x3A ':'
    { 314,  4,  9, 16,  5, -12 }, // 0x3B ';'
    { 319,  9, 14, 16,  3, -15 }, // 0x3C '<'
    { 335, 12,  6, 16,  2, -11 }, // 0x3D '='
    { 344,  9, 14, 16,  3, -15 }, // 0x3E '>'
    { 360, 10, 14, 16,  3, -15 }, // 0x3F '?'
    { 378, 11, 14, 16,  3, -15 }, // 0x40 '@'
    { 398, 10, 12, 16,  3, -14 }, // 0x41 'A'
    { 413, 10, 12, 16,  3, -14 }, // 0x42 'B'
    { 428, 10, 12, 16,  3, -14 }, // 0x43 'C'
    { 443, 10, 12, 16,  3, -14 }, // 0x44 'D'
    { 458, 10, 12, 16,  3, -14 }, // 0x45 'E'
    { 473, 10, 12, 16,  3, -14 }, // 0x46 'F'
    { 488, 10, 12, 16,  3, -14 }, // 0x47 'G'
    { 503,  9, 12, 16,  3, -14 }, // 0x48 'H'
    { 517,  7, 12, 16,  4, -14 }, // 0x49 'I'
    { 528, 12, 12, 16,  2, -14 }, // 0x4A 'J'
    { 546, 10, 12, 16,  3, -14 }, // 0x4B 'K'
    { 561, 10, 12, 16,  3, -14 }, // 0x4C 'L'
    { 576, 11, 12, 16,  3, -14 }, // 0x4D 'M'
    { 593, 11, 12, 16,  3, -14 }, // 0x4E 'N'
    { 610, 11, 12, 16,  3, -14 }, // 0x4F 'O'
    { 627, 10, 12, 16,  3, -14 }, // 0x50 'P'
    { 642, 11, 13, 16,  3, -14 }, // 0x51 'Q'
    { 660, 10, 12, 16,  3, -14 }, // 0x52 'R'
    { 675, 10, 12, 16,  3, -14 }, // 0x53 'S'
    { 690, 11, 12, 16,  3, -14 }, // 0x54 'T'
    { 707,  9, 12, 16,  3, -14 }, // 0x55 'U'
    { 721,  9, 12, 16,  3, -14 }, // 0x56 'V'
    { 735, 11, 12, 16,  3, -14 }, // 0x57 'W'
    { 752,  9, 12, 16,  3, -14 }, // 0x58 'X'
    { 766,  9, 12, 16,  3, -14 }, // 0x59 'Y'
    { 780, 10, 12, 16,  3, -14 }, // 0x5A 'Z'
    { 795,  7, 12, 16,  5, -14 }, // 0x5B '['
    { 806, 13, 12, 16,  3, -14 }, // 0x5C '\'
    { 826,  7, 12, 16,  5, -14 }, // 0x5D ']'
    { 837, 10,  5, 16,  3, -15 }, // 0x5E '^'
    { 844, 15,  2, 16,  1,  -2 }, // 0x5F '_'
    { 848,  5,  4, 16,  3, -14 }, // 0x60 '`'
    { 851, 10,  8, 16,  3, -10 }, // 0x61 'a'
    { 861, 10, 12, 16,  3, -14 }, // 0x62 'b'
    { 876,  9,  8, 16,  3, -10 }, // 0x63 'c'
    { 885, 10, 12, 16,  3, -14 }, // 0x64 'd'
    { 900,  9,  8, 16,  3, -10 }, // 0x65 'e'
    { 909,  9, 12, 16,  3, -14 }, // 0x66 'f'
    { 923, 10, 10, 16,  3, -10 }, // 0x67 'g'
    { 936, 10, 12, 16,  3, -14 }, // 0x68 'h'
    { 951,  9, 12, 16,  4, -14 }, // 0x69 'i'
    { 965,  9, 14, 16,  3, -14 }, // 0x6A 'j'
    { 981, 10, 12, 16,  3, -14 }, // 0x6B 'k'
    { 996,  9, 12, 16,  4, -14 }, // 0x6C 'l'
    {1010, 11,  8, 16,  3, -10 }, // 0x6D 'm'
    {1021,  9,  8, 16,  3, -10 }, // 0x6E 'n'
    {1030,  9,  8, 16,  3, -10 }, // 0x6F 'o'
    {1039, 10, 10, 16,  3, -10 }, // 0x70 'p'
    {1052, 10, 10, 16,  2, -10 }, // 0x71 'q'
    {1065, 10,  8, 16,  3, -10 }, // 0x72 'r'
    {1075,  9,  8, 16,  3, -10 }, // 0x73 's'
    {1084,  9, 11, 16,  3, -13 }, // 0x74 't'
    {1097, 10,  8, 16,  3, -10 }, // 0x75 'u'
    {1107,  9,  8, 16,  3, -10 }, // 0x76 'v'
    {1116, 11,  8, 16,  3, -10 }, // 0x77 'w'
    {1127,  8,  8, 16,  3, -10 }, // 0x78 'x'
    {1135, 10, 10, 16,  3, -10 }, // 0x79 'y'
    {1148,  8,  8, 16,  3, -10 }, // 0x7A 'z'
    {1156, 10, 12, 16,  3, -14 }, // 0x7B '{'
    {1171,  3, 14, 16,  7, -15 }, // 0x7C '|'
    {1177, 10, 12, 16,  3, -14 }, // 0x7D '}'
    {1192, 12,  4, 16,  2, -14 }, // 0x7E '~'
};
const GFXfont FreeBigFont PROGMEM = {
    (uint8_t  *)FreeBigFontBitmaps,
    (GFXglyph *)FreeBigFontGlyphs,
    32, 127, 16
};
// FreeBigFont bitmap size = 1198 [1863] [3139]
const uint8_t FreeSevenSegNumFontBitmaps[] PROGMEM = {
// 27x46 [0x30 '0']
0x03,0xFF,0xF8,0x00,0xFF,0xFF,0x80,0x3F,0xFF,0xF8,0x03,0xFF,0xFE,0xC3,0x3F,0xFF,
0xBC,0xF0,0x00,0x0F,0xFF,0x00,0x01,0xFF,0xE0,0x00,0x3F,0xFC,0x00,0x07,0xFF,0x80,
0x00,0xFF,0xF0,0x00,0x1F,0xFE,0x00,0x03,0xFF,0xC0,0x00,0x7F,0xF8,0x00,0x0F,0xFF,
0x00,0x01,0xFF,0xE0,0x00,0x3F,0xFC,0x00,0x07,0xFF,0x80,0x00,0xFF,0xF0,0x00,0x1F,
0xFC,0x00,0x00,0xFE,0x00,0x00,0x07,0x00,0x00,0x00,0x40,0x00,0x00,0x04,0x00,0x00,
0x00,0xE0,0x00,0x00,0x7F,0x00,0x00,0x3F,0xF0,0x00,0x1F,0xFE,0x00,0x03,0xFF,0xC0,
0x00,0x7F,0xF8,0x00,0x0F,0xFF,0x00,0x01,0xFF,0xE0,0x00,0x3F,0xFC,0x00,0x07,0xFF,
0x80,0x00,0xFF,0xF0,0x00,0x1F,0xFE,0x00,0x03,0xFF,0xC0,0x00,0x7F,0xF8,0x00,0x0F,
0xFF,0x00,0x01,0xFF,0xE0,0x00,0x3F,0x78,0x00,0x03,0xC6,0x7F,0xFF,0x30,0x1F,0xFF,
0xF0,0x07,0xFF,0xFF,0x00,0x7F,0xFF,0xC0,0x07,0xFF,0xF0,0x00,
// 6x39 [0x31 '1']
0x31,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3C,0x30,0x40,0x00,
0x33,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0xE3,0x00,
// 27x46 [0x32 '2']
0x03,0xFF,0xF8,0x00,0xFF,0xFF,0x80,0x3F,0xFF,0xF8,0x03,0xFF,0xFE,0xC0,0x3F,0xFF,
0xBC,0x00,0x00,0x0F,0xC0,0x00,0x01,0xF8,0x00,0x00,0x3F,0x00,0x00,0x07,0xE0,0x00,
0x00,0xFC,0x00,0x00,0x1F,0x80,0x00,0x03,0xF0,0x00,0x00,0x7E,0x00,0x00,0x0F,0xC0,
0x00,0x01,0xF8,0x00,0x00,0x3F,0x00,0x00,0x07,0xE0,0x00,0x00,0xFC,0x00,0x00,0x1F,
0x80,0x00,0x00,0xF0,0x7F,0xFF,0x86,0x1F,0xFF,0xFC,0x4F,0xFF,0xFF,0xE4,0xFF,0xFF,
0xF8,0xE7,0xFF,0xFC,0x1F,0x00,0x00,0x03,0xF0,0x00,0x00,0x7E,0x00,0x00,0x0F,0xC0,
0x00,0x01,0xF8,0x00,0x00,0x3F,0x00,0x00,0x07,0xE0,0x00,0x00,0xFC,0x00,0x00,0x1F,
0x80,0x00,0x03,0xF0,0x00,0x00,0x7E,0x00,0x00,0x0F,0xC0,0x00,0x01,0xF8,0x00,0x00,
0x3F,0x00,0x00,0x07,0xE0,0x00,0x00,0x78,0x00,0x00,0x06,0x7F,0xFF,0x00,0x1F,0xFF,
0xF0,0x07,0xFF,0xFF,0x00,0x7F,0xFF,0xC0,0x07,0xFF,0xF0,0x00,
// 25x46 [0x33 '3']
0x0F,0xFF,0xE0,0x0F,0xFF,0xF8,0x0F,0xFF,0xFE,0x03,0xFF,0xFE,0xC0,0xFF,0xFE,0xF0,
0x00,0x00,0xFC,0x00,0x00,0x7E,0x00,0x00,0x3F,0x00,0x00,0x1F,0x80,0x00,0x0F,0xC0,
0x00,0x07,0xE0,0x00,0x03,0xF0,0x00,0x01,0xF8,0x00,0x00,0xFC,0x00,0x00,0x7E,0x00,
0x00,0x3F,0x00,0x00,0x1F,0x80,0x00,0x0F,0xC0,0x00,0x07,0xE0,0x00,0x00,0xF1,0xFF,
0xFE,0x19,0xFF,0xFF,0xC7,0xFF,0xFF,0xF8,0xFF,0xFF,0xF8,0x1F,0xFF,0xF1,0x80,0x00,
0x03,0xC0,0x00,0x07,0xE0,0x00,0x03,0xF0,0x00,0x01,0xF8,0x00,0x00,0xFC,0x00,0x00,
0x7E,0x00,0x00,0x3F,0x00,0x00,0x1F,0x80,0x00,0x0F,0xC0,0x00,0x07,0xE0,0x00,0x03,
0xF0,0x00,0x01,0xF8,0x00,0x00,0xFC,0x00,0x00,0x7E,0x00,0x00,0x3F,0x00,0x00,0x0F,
0x07,0xFF,0xF3,0x07,0xFF,0xFC,0x07,0xFF,0xFF,0x01,0xFF,0xFF,0x00,0x7F,0xFF,0x00,
// 27x39 [0x34 '4']
0x00,0x00,0x01,0x86,0x00,0x00,0x79,0xE0,0x00,0x1F,0xFE,0x00,0x03,0xFF,0xC0,0x00,
0x7F,0xF8,0x00,0x0F,0xFF,0x00,0x01,0xFF,0xE0,0x00,0x3F,0xFC,0x00,0x07,0xFF,0x80,
0x00,0xFF,0xF0,0x00,0x1F,0xFE,0x00,0x03,0xFF,0xC0,0x00,0x7F,0xF8,0x00,0x0F,0xFF,
0x00,0x01,0xFF,0xE0,0x00,0x3F,0xF8,0x00,0x01,0xFC,0xFF,0xFF,0x0E,0x3F,0xFF,0xF8,
0x9F,0xFF,0xFF,0xC1,0xFF,0xFF,0xF0,0x0F,0xFF,0xF8,0xC0,0x00,0x00,0x78,0x00,0x00,
0x3F,0x00,0x00,0x07,0xE0,0x00,0x00,0xFC,0x00,0x00,0x1F,0x80,0x00,0x03,0xF0,0x00,
0x00,0x7E,0x00,0x00,0x0F,0xC0,0x00,0x01,0xF8,0x00,0x00,0x3F,0x00,0x00,0x07,0xE0,
0x00,0x00,0xFC,0x00,0x00,0x1F,0x80,0x00,0x03,0xF0,0x00,0x00,0x7E,0x00,0x00,0x07,
0x80,0x00,0x00,0x60,
// 27x46 [0x35 '5']
0x03,0xFF,0xF8,0x00,0xFF,0xFF,0x80,0x3F,0xFF,0xF8,0x03,0xFF,0xFE,0x03,0x3F,0xFF,
0x80,0xF0,0x00,0x00,0x3F,0x00,0x00,0x07,0xE0,0x00,0x00,0xFC,0x00,0x00,0x1F,0x80,
0x00,0x03,0xF0,0x00,0x00,0x7E,0x00,0x00,0x0F,0xC0,0x00,0x01,0xF8,0x00,0x00,0x3F,
0x00,0x00,0x07,0xE0,0x00,0x00,0xFC,0x00,0x00,0x1F,0x80,0x00,0x03,0xF0,0x00,0x00,
0x7C,0x00,0x00,0x0E,0x7F,0xFF,0x81,0x1F,0xFF,0xFC,0x0F,0xFF,0xFF,0xE0,0xFF,0xFF,
0xF8,0x07,0xFF,0xFC,0x60,0x00,0x00,0x3C,0x00,0x00,0x1F,0x80,0x00,0x03,0xF0,0x00,
0x00,0x7E,0x00,0x00,0x0F,0xC0,0x00,0x01,0xF8,0x00,0x00,0x3F,0x00,0x00,0x07,0xE0,
0x00,0x00,0xFC,0x00,0x00,0x1F,0x80,0x00,0x03,0xF0,0x00,0x00,0x7E,0x00,0x00,0x0F,
0xC0,0x00,0x01,0xF8,0x00,0x00,0x3F,0x00,0x00,0x03,0xC0,0x7F,0xFF,0x30,0x1F,0xFF,
0xF0,0x07,0xFF,0xFF,0x00,0x7F,0xFF,0xC0,0x07,0xFF,0xF0,0x00,
// 27x46 [0x36 '6']
0x03,0xFF,0xF8,0x00,0xFF,0xFF,0x80,0x3F,0xFF,0xF8,0x03,0xFF,0xFE,0x03,0x3F,0xFF,
0x80,0xF0,0x00,0x00,0x3F,0x00,0x00,0x07,0xE0,0x00,0x00,0xFC,0x00,0x00,0x1F,0x80,
0x00,0x03,0xF0,0x00,0x00,0x7E,0x00,0x00,0x0F,0xC0,0x00,0x01,0xF8,0x00,0x00,0x3F,
0x00,0x00,0x07,0xE0,0x00,0x00,0xFC,0x00,0x00,0x1F,0x80,0x00,0x03,0xF0,0x00,0x00,
0x7C,0x00,0x00,0x0E,0x7F,0xFF,0x81,0x1F,0xFF,0xFC,0x0F,0xFF,0xFF,0xE4,0xFF,0xFF,
0xF8,0xE7,0xFF,0xFC,0x7F,0x00,0x00,0x3F,0xF0,0x00,0x1F,0xFE,0x00,0x03,0xFF,0xC0,
0x00,0x7F,0xF8,0x00,0x0F,0xFF,0x00,0x01,0xFF,0xE0,0x00,0x3F,0xFC,0x00,0x07,0xFF,
0x80,0x00,0xFF,0xF0,0x00,0x1F,0xFE,0x00,0x03,0xFF,0xC0,0x00,0x7F,0xF8,0x00,0x0F,
0xFF,0x00,0x01,0xFF,0xE0,0x00,0x3F,0x78,0x00,0x03,0xC6,0x7F,0xFF,0x30,0x1F,0xFF,
0xF0,0x07,0xFF,0xFF,0x00,0x7F,0xFF,0xC0,0x07,0xFF,0xF0,0x00,
// 23x42 [0x37 '7']
0x3F,0xFF,0x80,0xFF,0xFF,0x83,0xFF,0xFF,0x83,0xFF,0xFE,0xC3,0xFF,0xFB,0xC0,0x00,
0x0F,0xC0,0x00,0x1F,0x80,0x00,0x3F,0x00,0x00,0x7E,0x00,0x00,0xFC,0x00,0x01,0xF8,
0x00,0x03,0xF0,0x00,0x07,0xE0,0x00,0x0F,0xC0,0x00,0x1F,0x80,0x00,0x3F,0x00,0x00,
0x7E,0x00,0x00,0xFC,0x00,0x01,0xF8,0x00,0x00,0xF0,0x00,0x00,0x60,0x00,0x00,0x40,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x3C,0x00,0x01,0xF8,0x00,0x03,
0xF0,0x00,0x07,0xE0,0x00,0x0F,0xC0,0x00,0x1F,0x80,0x00,0x3F,0x00,0x00,0x7E,0x00,
0x00,0xFC,0x00,0x01,0xF8,0x00,0x03,0xF0,0x00,0x07,0xE0,0x00,0x0F,0xC0,0x00,0x1F,
0x80,0x00,0x3F,0x00,0x00,0x3C,0x00,0x00,0x30,
// 27x46 [0x38 '8']
0x03,0xFF,0xF8,0x00,0xFF,0xFF,0x80,0x3F,0xFF,0xF8,0x03,0xFF,0xFE,0xC3,0x3F,0xFF,
0xBC,0xF0,0x00,0x0F,0xFF,0x00,0x01,0xFF,0xE0,0x00,0x3F,0xFC,0x00,0x07,0xFF,0x80,
0x00,0xFF,0xF0,0x00,0x1F,0xFE,0x00,0x03,0xFF,0xC0,0x00,0x7F,0xF8,0x00,0x0F,0xFF,
0x00,0x01,0xFF,0xE0,0x00,0x3F,0xFC,0x00,0x07,0xFF,0x80,0x00,0xFF,0xF0,0x00,0x1F,
0xFC,0x00,0x00,0xFE,0x7F,0xFF,0x87,0x1F,0xFF,0xFC,0x4F,0xFF,0xFF,0xE4,0xFF,0xFF,
0xF8,0xE7,0xFF,0xFC,0x7F,0x00,0x00,0x3F,0xF0,0x00,0x1F,0xFE,0x00,0x03,0xFF,0xC0,
0x00,0x7F,0xF8,0x00,0x0F,0xFF,0x00,0x01,0xFF,0xE0,0x00,0x3F,0xFC,0x00,0x07,0xFF,
0x80,0x00,0xFF,0xF0,0x00,0x1F,0xFE,0x00,0x03,0xFF,0xC0,0x00,0x7F,0xF8,0x00,0x0F,
0xFF,0x00,0x01,0xFF,0xE0,0x00,0x3F,0x78,0x00,0x03,0xC6,0x7F,0xFF,0x30,0x1F,0xFF,
0xF0,0x07,0xFF,0xFF,0x00,0x7F,0xFF,0xC0,0x07,0xFF,0xF0,0x00,
// 27x46 [0x39 '9']
0x03,0xFF,0xF8,0x00,0xFF,0xFF,0x80,0x3F,0xFF,0xF8,0x03,0xFF,0xFE,0xC3,0x3F,0xFF,
0xBC,0xF0,0x00,0x0F,0xFF,0x00,0x01,0xFF,0xE0,0x00,0x3F,0xFC,0x00,0x07,0xFF,0x80,
0x00,0xFF,0xF0,0x00,0x1F,0xFE,0x00,0x03,0xFF,0xC0,0x00,0x7F,0xF8,0x00,0x0F,0xFF,
0x00,0x01,0xFF,0xE0,0x00,0x3F,0xFC,0x00,0x07,0xFF,0x80,0x00,0xFF,0xF0,0x00,0x1F,
0xFC,0x00,0x00,0xFE,0x7F,0xFF,0x87,0x1F,0xFF,0xFC,0x4F,0xFF,0xFF,0xE0,0xFF,0xFF,
0xF8,0x07,0xFF,0xFC,0x60,0x00,0x00,0x3C,0x00,0x00,0x1F,0x80,0x00,0x03,0xF0,0x00,
0x00,0x7E,0x00,0x00,0x0F,0xC0,0x00,0x01,0xF8,0x00,0x00,0x3F,0x00,0x00,0x07,0xE0,
0x00,0x00,0xFC,0x00,0x00,0x1F,0x80,0x00,0x03,0xF0,0x00,0x00,0x7E,0x00,0x00,0x0F,
0xC0,0x00,0x01,0xF8,0x00,0x00,0x3F,0x00,0x00,0x03,0xC0,0x7F,0xFF,0x30,0x1F,0xFF,
0xF0,0x07,0xFF,0xFF,0x00,0x7F,0xFF,0xC0,0x07,0xFF,0xF0,0x00,
};
const GFXglyph FreeSevenSegNumFontGlyphs[] PROGMEM = {
    {   0, 27, 46, 32,  2, -48 }, // 0x30 '0'
    { 156,  6, 39, 32, 23, -45 }, // 0x31 '1'
    { 186, 27, 46, 32,  2, -48 }, // 0x32 '2'
    { 342, 25, 46, 32,  4, -48 }, // 0x33 '3'
    { 486, 27, 39, 32,  2, -45 }, // 0x34 '4'
    { 618, 27, 46, 32,  2, -48 }, // 0x35 '5'
    { 774, 27, 46, 32,  2, -48 }, // 0x36 '6'
    { 930, 23, 42, 32,  6, -48 }, // 0x37 '7'
    {1051, 27, 46, 32,  2, -48 }, // 0x38 '8'
    {1207, 27, 46, 32,  2, -48 }, // 0x39 '9'
};
const GFXfont FreeSevenSegNumFont PROGMEM = {
    (uint8_t  *)FreeSevenSegNumFontBitmaps,
    (GFXglyph *)FreeSevenSegNumFontGlyphs,
    48, 58, 50
};
// FreeSevenSegNumFont bitmap size = 1363 [1433] [2014]

